require( "scripts/style.lua" );

kButtonSpacingY = 30;		-- Put our buttons N pixels apart
kButtonY = 50;				-- 

MakeDialog
{
	-- Name the modal dialog
	name = "pausemenu",
	
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		
		Bitmap
		{
			image = "backgrounds/dialog",
			mask = exists("backgrounds/dialog.mask.png"),
			x = kCenter,
			y = kCenter,

			SetStyle(ThinButtonStyle),
			Button
			{
				x = kCenter,
				y = kButtonY + (kButtonSpacingY * 0),
				label = "resume",
				command = StartClose, -- Just close this window
			},
			Button
			{
				x = kCenter,
				y = kButtonY + (kButtonSpacingY * 1),
				label = "options",
				command = function()
					-- Pop up an options screen
					DoModal("scripts/options.lua");
				end
			},
			Button
			{
				x = kCenter,
				y = kButtonY + (kButtonSpacingY * 2),
				label = "help",
				command = function()
					-- Pop up a help screen
					MET_BeginHelp();
					DoModal("scripts/help.lua");
					MET_EndHelp();
				end
			},
			
			Button
			{
				x = kCenter,
				y = kButtonY + (kButtonSpacingY * 3),
				label="quit",
				command = function()
					
					qv_reentry = true;

					DisplayDialog
					{
						"scripts/yesno.lua",
						yes = function()
							SendGameMessage( "quit" );
							-- PostMessage( CreateNamedMessage( kQuitNow, "quit" ) );
						end,
						title = "quit_ingame_title",
						body = "quit_ingame_body",
						noslide = true,
					};

					qv_reentry = false;
	
					-- DoModal("scripts/quitexplain.lua");

				end
			},

			Button
			{
				x = kMax-140,
				y = kMax-40,
				label = "choosescene",
				name = "choosescene",
				command = function()
					-- Maybe pick a new scene
					if DoModal("scripts/choosescene.lua") then
						CloseWindow();
					end
				end
			},
			
--[[
			Button
			{
				x = kCenter,
				y = kButtonY + (kButtonSpacingY * 1),
				label = "PAUSE_savegame",
				name = "savegame",
				command = function()
					local answer;
					gDialogTable = { 
						yeslabel = "SAVE_yeslabel", 
						nolabel = "SAVE_nolabel",
						body = "SAVE_body",
						title = "SAVE_title",
						yes = function()
							answer = "yes";
						end;
						no = function()
							answer = "no";
						end;
						};
					DoModal("scripts/yesno.lua");
					
					if answer == "yes" then
						game:SaveGame();
					elseif answer == "no" then
						-- cancel
					else
						-- didn't get an answer?
					end;
				end
			},
	--]]		
			
		},
	},
};

function UpdateCheat()
	local cheatmode = IsEnabled(kCheatMode);
	EnableWindow('choosescene', cheatmode);
end

UpdateCheat();

MET_Count("TimesPaused");
